/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.impl.Messages;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;

public class FindHelper {
    public static void findInOpenDocuments(String searchText, boolean caseSensitive, boolean wholeWord, boolean isRegEx, IStatusLineManager statusLineManager) {
        IWorkbenchPage activePage = FindHelper.getActivePage(statusLineManager);
        if (activePage == null) {
            return;
        }
        IEditorReference[] editorsArray = activePage.getEditorReferences();
        ArrayList<IFile> files = new ArrayList<IFile>();
        int i = 0;
        while (i < editorsArray.length) {
            IEditorPart realEditor = editorsArray[i].getEditor(true);
            if (realEditor != null) {
                if (realEditor instanceof MultiPageEditorPart) {
                    try {
                        Method getPageCount = MultiPageEditorPart.class.getDeclaredMethod("getPageCount", new Class[0]);
                        getPageCount.setAccessible(true);
                        Method getEditor = MultiPageEditorPart.class.getDeclaredMethod("getEditor", Integer.TYPE);
                        getEditor.setAccessible(true);
                        Integer pageCount = (Integer)getPageCount.invoke((Object)realEditor, new Object[0]);
                        int j = 0;
                        while (j < pageCount) {
                            IFile file;
                            IEditorInput input;
                            IEditorPart part = (IEditorPart)getEditor.invoke((Object)realEditor, j);
                            if (part != null && (input = part.getEditorInput()) != null && (file = (IFile)input.getAdapter(IFile.class)) != null) {
                                files.add(file);
                            }
                            ++j;
                        }
                    }
                    catch (Throwable e1) {
                        FindBarPlugin.log(e1);
                    }
                } else {
                    IEditorInput input = realEditor.getEditorInput();
                    if (input != null) {
                        IFile file = (IFile)input.getAdapter(IFile.class);
                        if (file != null) {
                            files.add(file);
                        } else if (statusLineManager != null) {
                            statusLineManager.setMessage(Messages.FindInOpenDocuments_FileNotInWorkspace);
                        }
                    }
                }
            }
            ++i;
        }
        if (files.size() == 0) {
            if (statusLineManager != null) {
                statusLineManager.setMessage(Messages.FindInOpenDocuments_NoFileFound);
            }
            return;
        }
        FindHelper.performFind(searchText, caseSensitive, isRegEx, FileTextSearchScope.newSearchScope((IResource[])files.toArray(new IResource[files.size()]), (String[])new String[]{"*"}, (boolean)true));
    }

    public static void findInEnclosingProject(String searchText, boolean caseSensitive, boolean wholeWord, boolean isRegEx, IStatusLineManager statusLineManager) {
        IWorkbenchPage activePage = FindHelper.getActivePage(statusLineManager);
        if (activePage == null) {
            return;
        }
        IProject activeProject = null;
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor instanceof MultiPageEditorPart) {
            try {
                Method getPageCount = MultiPageEditorPart.class.getDeclaredMethod("getPageCount", new Class[0]);
                getPageCount.setAccessible(true);
                Method getEditor = MultiPageEditorPart.class.getDeclaredMethod("getEditor", Integer.TYPE);
                getEditor.setAccessible(true);
                Integer pageCount = (Integer)getPageCount.invoke((Object)activeEditor, new Object[0]);
                int j = 0;
                while (j < pageCount) {
                    IProject project;
                    IFile file;
                    IEditorInput input;
                    IEditorPart part = (IEditorPart)getEditor.invoke((Object)activeEditor, j);
                    if (part != null && (input = part.getEditorInput()) != null && (file = (IFile)input.getAdapter(IFile.class)) != null && (project = file.getProject()) != null) {
                        activeProject = (IProject)project.getAdapter(IProject.class);
                    }
                    ++j;
                }
            }
            catch (Throwable e1) {
                FindBarPlugin.log(e1);
            }
        } else {
            IProject project;
            IFile file;
            IEditorInput input = activeEditor.getEditorInput();
            if (input != null && (file = (IFile)input.getAdapter(IFile.class)) != null && (project = file.getProject()) != null) {
                activeProject = (IProject)project.getAdapter(IProject.class);
            }
        }
        if (activeProject == null) {
            if (statusLineManager != null) {
                statusLineManager.setMessage(Messages.FindInOpenDocuments_FileNotInWorkspace);
            }
            return;
        }
        FindHelper.performFind(searchText, caseSensitive, isRegEx, FileTextSearchScope.newSearchScope((IResource[])new IResource[]{activeProject}, (String[])new String[]{"*"}, (boolean)true));
    }

    public static void findInWorkspace(String searchText, boolean caseSensitive, boolean wholeWord, boolean isRegEx, IStatusLineManager statusLineManager) {
        if (FindHelper.getActivePage(statusLineManager) == null) {
            return;
        }
        FindHelper.performFind(searchText, caseSensitive, isRegEx, FileTextSearchScope.newSearchScope((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (String[])new String[]{"*"}, (boolean)true));
    }

    private static IWorkbenchPage getActivePage(IStatusLineManager statusLineManager) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            if (statusLineManager != null) {
                statusLineManager.setErrorMessage(Messages.FindHelper_Error_workbench_window_null);
            }
            return null;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null && statusLineManager != null) {
            statusLineManager.setErrorMessage(Messages.FindHelper_Error_active_page_null);
        }
        return activePage;
    }

    private static void performFind(final String searchText, final boolean caseSensitive, final boolean isRegEx, final FileTextSearchScope searchScope) {
        try {
            ISearchQuery query = TextSearchQueryProvider.getPreferred().createQuery(new TextSearchQueryProvider.TextSearchInput(){

                public boolean isRegExSearch() {
                    return isRegEx;
                }

                public boolean isCaseSensitiveSearch() {
                    return caseSensitive;
                }

                public String getSearchText() {
                    return searchText;
                }

                public FileTextSearchScope getScope() {
                    return searchScope;
                }
            });
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
        catch (CoreException e1) {
            FindBarPlugin.log(e1);
        }
    }
}

